#!/bin/bash


WIDTH=1800
HEIGHT=1200

jhead -autorot *.jpg

for file in *.jpg; do 
    echo -n "Resizing $file .... "
    W=`identify $file | cut -d' '  -f3| cut -d 'x' -f1`
    H=`identify $file | cut -d' '  -f3| cut -d 'x' -f2`
    echo -n "${W}x$H ... "
    
    if (( ("$W" <= $WIDTH && "$H" <= $HEIGHT) || ("$H" <= $WIDTH && "$W" <= $HEIGHT) ))
    then 
        echo "no need"
        continue
    fi

    if (( "$W" > "$H" )) 
    then
        convert $file -resize ${WIDTH}x${HEIGHT} $file
    else
        convert $file -resize ${HEIGHT}x${WIDTH} $file
    fi

   echo ok
done
